﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Ozeki.Media.MediaHandlers;

namespace OPSIVRSystem.IVRMenus
{
    class IVRMenuNarratorTextToSpeech :IVRMenuNarrator
    {
        /// <summary>
        /// text to speech reader.
        /// </summary>
        private TextToSpeech txtToSpeech;

        public override void StartNarration(string textInfo)
        {
            txtToSpeech = new TextToSpeech();
            txtToSpeech.Stopped += txtToSpeech_Stopped;
            OnNarrationStarting();
            txtToSpeech.AddText(textInfo);
            txtToSpeech.Start();
        }

        public override void StopNarration()
        {
            txtToSpeech.Stop();
        }

        public override void RestartNarration(string textInfo)
        {
            txtToSpeech.AddText(textInfo);
            txtToSpeech.Start();
        }

        public override IAudioSender GetMediaHandler()
        {
            return txtToSpeech;
        }

        void txtToSpeech_Stopped(object sender, EventArgs e)
        {
            OnNarrationFinished();
        }
    }
}
