import urllib
import urllib.parse
import urllib.request
import urllib.response

def application(environ, start_response):

    result = ""
    if(environ["PATH_INFO"] == ''):
        result = sendSms()
    elif(environ["PATH_INFO"] == '/DeliveryReportReceived'):
        result = receiveDeliveryReport(environ)
    
    status = '200 OK'

    response_headers = [('Content-type', 'text/plain'), ('Content-Length', str(len(result)))]
    start_response(status, response_headers)

    return [result]

def sendSms():    
    dict = {}
    dict["Sender"] = "+36301234567"
    dict["Recipient"] = "+36301234568"
    dict["Message"] = "Test message from Python"
    dict["ApiExtension"] = "9997"
    dict["DeliveryReportURL"] = "http://localhost/SendSms/DeliveryReportReceived"
    
    opsLocation = "localhost"
    opsPort = 7780
    result = ""

    try:
        requestUrl = "http://{}:{}/?Command=SendSms&{}".format(opsLocation, opsPort, urllib.parse.urlencode(dict))
        
        result += requestUrl
        request = urllib.request.Request(requestUrl)
        response = urllib.request.urlopen(request)

        if(response.status != 200):
            result += "\r\nThe HTTP Status received indicates errors: {}".format(response.status)
            return result

    except Exception:
        result += "\r\nError occured while sending the HTTP request: {}".format(Exception)
        return result

    result += "\r\nSMS successfully sent."
    return result

def receiveDeliveryReport(environ):
    body = ""

    try:
        length= int(environ.get('CONTENT_LENGTH', '0'))
    except ValueError:
        length= 0

    try:
        if(length != 0):
            body = environ['wsgi.input'].read(length)
            receivedData = urllib.parse.parse_qs(str(body))

            f = open('D:/receivedDeliveryReport.txt', 'w')
            for key, value in receivedData.items():
                f.write("{}: {}\r\n".format(str(key), str(value)))
            f.close()

    except IOError:
        pass