import urllib
import urllib.parse
import urllib.request
import urllib.response
import datetime
from cgi import escape

def application(environ, start_response):
    
    result = receiveCall(environ)
    status = '200 OK'

    response_headers = [('Content-type', 'text/plain'), ('Content-Length', str(len(result)))]
    start_response(status, response_headers)

    return [result]

def receiveCall(environ):
    today = datetime.datetime.now();

    try:
        length= int(environ.get('CONTENT_LENGTH', '0'))

        if(length != 0):
            body = environ['wsgi.input'].read(length)
            receivedData = urllib.parse.parse_qs(str(body))
            caller = escape(receivedData['Caller'][0])

    except IOError:
        return ""

    return """<?xml version="1.0" encoding="UTF-8"?>
        <Response>
            <Delay>1</Delay>
            <Speak>Congratulations, you received a test call from {1} at {0} with the python example program.</Speak>
            <Delay>1</Delay>
            <Speak>For more information, visit www.ozekiphone.com</Speak>
        </Response>""".format(today.strftime("%Y-%m-%d %H:%M"), caller)