import urllib
import urllib.parse
import urllib.request
import urllib.response
import datetime
from cgi import escape

def application(environ, start_response):
    
    result = ""
    if(environ["PATH_INFO"] == ''):
        result = createCall()
    elif(environ["PATH_INFO"] == '/CallCreated'):
        result = getOzmlResponse(environ)
    elif(environ["PATH_INFO"] == '/CallErrorOccured'):
        result = callErrorOccured(environ)

    status = '200 OK'

    response_headers = [('Content-type', 'text/plain'), ('Content-Length', str(len(result)))]
    start_response(status, response_headers)

    return [result]

def createCall():    
    dict = {}
    dict["Dialed"] = "1200"
    dict["CallerId"] = "1201"
    dict["CallerDisplayName"] = "Mr. Test"
    dict["ApiExtension"] = "9997"
    dict["Url"] = "http://localhost/CreateCall/CallCreated"
    dict["ErrorUrl"] = "http://localhost/CreateCall/CallErrorOccured"
    
    opsLocation = "localhost"
    opsPort = 7780
    result = ""

    try:
        requestUrl = "http://{}:{}/?Command=Call&{}".format(opsLocation, opsPort, urllib.parse.urlencode(dict))
        
        result += requestUrl
        request = urllib.request.Request(requestUrl)
        response = urllib.request.urlopen(request)

        if(response.status != 200):
            result += "\r\nThe HTTP Status received indicates errors: {}".format(response.status)
            return result

    except Exception:
        result += "\r\nError occured while sending the HTTP request: {}".format(Exception)
        return result

    result += "\r\nCall successfully created."
    return result

def getOzmlResponse(environ):

    today = datetime.datetime.now();

    try:
        length= int(environ.get('CONTENT_LENGTH', '0'))

        if(length != 0):
            body = environ['wsgi.input'].read(length)
            receivedData = urllib.parse.parse_qs(str(body))
            callee = escape(receivedData['Callee'][0])

    except IOError:
        return ""

    return """<?xml version="1.0" encoding="UTF-8"?>
        <Response>
            <Delay>1</Delay>
            <Speak>Congratulations, you have initiated a test call to {1} at {0} from the python example program.</Speak>
            <Delay>1</Delay>
            <Speak>For more information, visit www.ozekiphone.com</Speak>
        </Response>""".format(today.strftime("%Y-%m-%d %H:%M"), callee)


def callErrorOccured(environ):
    body = ""

    try:
        length= int(environ.get('CONTENT_LENGTH', '0'))
    except ValueError:
        length= 0

    try:
        if(length != 0):
            body = environ['wsgi.input'].read(length)
            receivedData = (str(body))

            f = open('D:/callErrorOccured.txt', 'w')
            f.write(receivedData)
            f.close()

    except IOError:
        pass