﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using OPSSDK;
using OPSSDKCommon.Model;
using OPSSDKCommon.Model.Extension;
using Ozeki.VoIP;

namespace OzCommon.Model.Mock
{
    public class MockClient : IClient
    {
        public event EventHandler <ErrorInfo> ErrorOccurred;
        public event EventHandler<VoIPEventArgs<ISession>> SessionCreated;
        public event EventHandler<VoIPEventArgs<ISession>> SessionCompleted;
        
        event EventHandler<VoIPEventArgs<IUser>> IClient.UserAdded
        {
            add { throw new NotImplementedException(); }
            remove { throw new NotImplementedException(); }
        }

        event EventHandler<VoIPEventArgs<IUser>> IClient.UserRemoved
        {
            add { throw new NotImplementedException(); }
            remove { throw new NotImplementedException(); }
        }

        public bool Login(string serverAddress, string username, string password)
        {
            Thread.Sleep(1000);
            return true;
        }

        public void LoginAsync(string serverAddress, string username, string password, Action<bool> completed)
        {
            Task.Factory.StartNew(() =>
            {
                Thread.Sleep(1000);
                completed(true);
            });
        }


        List<IExtension> IClient.GetExtensions()
        {
            throw new NotImplementedException();
        }

        List<IUser> IClient.GetUserInfos()
        {
            throw new NotImplementedException();
        }

        public void GetExtensionsAsync(Action<List<IExtension>> completed)
        {
            throw new NotImplementedException();
        }

        public List<IExtension> GetExtensions()
        {
            throw new NotImplementedException();
        }

        public void GetIExtensionsAsync(Action<List<IExtension>> completed)
        {
            throw new NotImplementedException();
        }

        public IAPIExtension GetAPIExtension(string extensionName)
        {
            throw new NotImplementedException();
        }

        public void GetAPIExtensionAsync(string extensionName, Action<IAPIExtension> completed)
        {
            throw new NotImplementedException();
        }
    }
}
