﻿using System;
using System.Collections.Generic;
using OPSSDK;
using OPSSDKCommon.Model;
using OPSSDKCommon.Model.Extension;
using Ozeki.VoIP;

namespace OzCommon.Model
{
    public interface IClient
    {
        event EventHandler<ErrorInfo> ErrorOccurred;
        event EventHandler<VoIPEventArgs<ISession>> SessionCreated;
        event EventHandler<VoIPEventArgs<ISession>> SessionCompleted;
        event EventHandler<VoIPEventArgs<IUser>> UserAdded;
        event EventHandler<VoIPEventArgs<IUser>> UserRemoved;

        bool Login(string serverAddress, string username, string password);
        void LoginAsync(string serverAddress, string username, string password, Action<bool> completed);
        List<IExtension> GetExtensions();
        List<IUser> GetUserInfos();
        void GetExtensionsAsync(Action<List<IExtension>> completed);
        IAPIExtension GetAPIExtension(string extensionName);
        void GetAPIExtensionAsync(string extensionName, Action<IAPIExtension> completed);
    }
}
